IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Contratos_Cupos_Contar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Contratos_Cupos_Contar
END
GO

CREATE FUNCTION [dbo].[CF_Contratos_Cupos_Contar] 
(		@pId_Familia				INT
		,@pId_Prod_Familia_Sala		INT
		,@pId_Prod_Familia_Horario	INT
		,@pId_Producto				CHAR(14)
		,@pFecha					DATETIME
		,@pId_Contrato				INT = NULL /*21/02/2020. Si @pId_Contrato <> 0 se tiene que exluir de la suma (porque es un updaet)*/
)		
RETURNS INT
AS
BEGIN
	DECLARE @Flag_Valida_Cupo	TINYINT
			,@Cant INT

	SELECT @Flag_Valida_Cupo = Flag_Valida_Cupo FROM Prod_Familias WHERE Id_Familia = @pId_Familia

	IF @Flag_Valida_Cupo = 0
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND ISNULL(C.Fecha_Hasta,@pFecha + 1) > @pFecha
							   AND P.Id_Producto = @pId_Producto
	   RETURN ISNULL(@Cant,0)
	END


	IF @Flag_Valida_Cupo = 1  --Por Sala
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND ISNULL(C.Fecha_Hasta,@pFecha + 1) > @pFecha
							   AND C.Id_Contrato <> @pId_Contrato
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
		
		if (@pid_familia in (1073,1072,1097,1252, 1096,1095,1272 ))
		begin
							  SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde >=getdate()
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
		end	

	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 2  --Por Sala Y Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P, Contratos_Prod_Horarios H
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND ISNULL(C.Fecha_Hasta,@pFecha + 1) > @pFecha
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							   AND H.Id_Contrato = C.Id_Contrato
							   AND C.Id_Contrato <> @pId_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 3  --Por Sala Y Producto
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND ISNULL(C.Fecha_Hasta,@pFecha + 1) > @pFecha
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato <> @pId_Contrato
	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 4  --Por Sala , Producto y Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P, Contratos_Prod_Horarios H
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND ISNULL(C.Fecha_Hasta,@pFecha + 1) > @pFecha
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							   AND H.Id_Contrato = C.Id_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato <> @pId_Contrato
	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 5  --Por Producto y Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P, Contratos_Prod_Horarios H
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND ISNULL(C.Fecha_Hasta,@pFecha + 1) > @pFecha
							   AND H.Id_Contrato = C.Id_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato <> @pId_Contrato
	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 6  --Por Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P, Contratos_Prod_Horarios H
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND ISNULL(C.Fecha_Hasta,@pFecha + 1) > @pFecha
							   AND H.Id_Contrato = C.Id_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato <> @pId_Contrato
	   RETURN ISNULL(@Cant,0)
	END
	
	IF @Flag_Valida_Cupo = 7  --Por Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod_Horarios H
                               WHERE C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND ISNULL(C.Fecha_Hasta,@pFecha + 1) > @pFecha
							   AND H.Id_Contrato = C.Id_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   AND C.Id_Contrato <> @pId_Contrato
	   RETURN ISNULL(@Cant,0)
	END

	RETURN ISNULL(@Cant,0)
END	
		
   
